/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterCUIDAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterCUIDAssertion extends BasicFilterAssertion implements IFilterCUIDAssertion {
	private String _assertion;
	
	public BasicFilterCUIDAssertion() {
		super();
	}
	
	public BasicFilterCUIDAssertion(URI id, String comparator) throws IdASException {
		super(id, false, comparator);
	}

	public BasicFilterCUIDAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
	}

	public BasicFilterCUIDAssertion(URI id, String comparator, String assertionValue) throws IdASException {
		super(id, comparator);
		setAssertionValue(assertionValue);
	}

	public BasicFilterCUIDAssertion(URI id, boolean bIncludeSubtypes, String comparator, String assertionValue) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
		setAssertionValue(assertionValue);
	}

	public void setAssertionValue(String assertion) throws IdASException {
		_assertion = assertion;
	}

	public String getAssertionValue() throws IdASException {
		return _assertion;
	}

}
