/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *    Tom Doman
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IMetadata;

public class MetadataNotification
{
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_ADD";
	public static final String UPDATE_DELETE = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_DELETE";
	public static final String UPDATE_SET_DATA = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_SET_DATA";

	private IMetadata _metadata;
	private String _action;
	private Object _oldData;

	/**
	 * 
	 * @param metadata
	 * @param action
	 * @param oldData
	 */
	MetadataNotification(
		IMetadata metadata,
		String action,
		Object oldData)
	{
		_metadata = metadata;
		_action = action;
		_oldData = oldData;
	}

	/**
	 * 
	 */
	public IMetadata getMetadata()
	{
		return _metadata;
	}

	/**
	 * 
	 */
	public String getAction()
	{
		return _action;
	}

	/**
	 * 
	 */
	public Object getOldData()
	{
		return _oldData;
	}
}
