/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial impl
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterCUIDAssertion;
import org.eclipse.higgins.idas.api.IFilterMetadataAssertion;
import org.eclipse.higgins.idas.api.IFilterTypeAssertion;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IContextRelationship;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidSubjectIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.SubjectExistsException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.api.model.IModel;

/**
 * Basic implementation of IContext.  
 * The intent of this class is to be used by Context Provider 
 * writers as a superclass for IContext instances.  The benefits of 
 * using this class are that you will pick up any convenience methods
 * as well as have the latest methods stubbed out such that when new
 * methods are added to IContext and implemented here, the subclass
 * will still compile.  
 *
 */
public class BasicContext extends BasicMetadataSet implements IContext, ISubjectContainer
{
	private Logger _log = Logger.getLogger(BasicContext.class.getName());
	private static Hashtable _typeToBasicMap = new Hashtable();
	private Hashtable _updateTable = new Hashtable();

	public BasicContext() throws IdASException {
		super();
	}

	public BasicContext(Iterator metadataSet) throws IdASException {
		super(metadataSet, null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#close()
	 */
	public void close() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#exportData(java.lang.String, java.lang.String)
	 */
	public String exportData(String filter, String representationFormat)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getContextModel()
	 */
	public IContextModel getContextModel() throws IdASException {
		throw new NotImplementedException();
	}

	public IModel getModel(URI elementType) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getContextRef()
	 */
	public URI getContextRef() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSchema()
	 */
	public String getSchema() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSubject(java.lang.String)
	 */
	public IDigitalSubject getSubject(String cuid) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSubject(java.lang.String, java.lang.Iterable)
	 */
	public IDigitalSubject getSubject(String cuid,
			Iterator attrSelectionList) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSubjects(org.eclipse.higgins.idas.api.IFilter)
	 */
	public Iterator getSubjects(IFilter filter)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSubjects(org.eclipse.higgins.idas.api.IFilter, java.lang.Iterable)
	 */
	public Iterator getSubjects(IFilter filter,
			Iterator attrs) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#importData(java.lang.String, java.lang.String)
	 */
	public void importData(String filter, String representationFormat)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#isOpen(java.lang.Object)
	 */
	public boolean isOpen(Object identity) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#open(java.lang.Object)
	 */
	public String open(Object authentication) throws IdASException,
			ContextOpenException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#setSchema(java.lang.String)
	 */
	public void setSchema(String schema) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#verifySubjectAttributes(java.lang.String, java.lang.Iterable)
	 */
	public boolean verifySubjectAttributes(String cuid,
			Iterator attributes) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IHasMetadata#getMetadataSet()
	 */
	public Iterator getMetadataSet() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.IHasRelationships#addRelationship(URI)
	 */
	public IContextRelationship addRelationship(URI relationshipType)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.IHasRelationships#getRelationships()
	 */
	public Iterator getRelationships() throws IdASException {
		throw new NotImplementedException();
	}

	public IFilterAttributeAssertion buildAttributeAssertion() throws IdASException {
		return new BasicFilterAttributeAssertion();
	}

	public IFilterCUIDAssertion buildCUIDAssertion() throws IdASException {
		return new BasicFilterCUIDAssertion();
	}

	public IFilter buildFilter() throws IdASException {
		return new BasicFilter();
	}

	public IFilterMetadataAssertion buildMetadataAssertion() throws IdASException {
		return new BasicFilterMetadataAssertion();
	}

	public IContextRelationship buildRelationship(URI type) throws IdASException {
		throw new NotImplementedException();
	}

	public IFilterTypeAssertion buildTypeAssertion() throws IdASException {
		return new BasicFilterTypeAssertion();
	}

	public ISimpleAttrValue buildSimpleAttrValue(URI type, Object data) throws IdASException {
		return createSimpleValue(type, data, null);
	}

	public static ISimpleAttrValue createSimpleValue(URI type, Object data, IAttributeValueContainer container) throws IdASException {
		_initTypeToBasicMap();
		Class valClass = (Class) _typeToBasicMap.get(type);
		Class dataClass = data.getClass();
		Class ctorClasses[] = {dataClass, IAttributeValueContainer.class};
		Object ctorArgs[] = {data, container};
		Constructor ctor = null;
		if (valClass == null) {
			Class basicCtorClasses[] = {URI.class, Object.class, IAttributeValueContainer.class};
			Object basicCtorArgs[] = {type, data, container};
			valClass = BasicSimpleValue.class;
			ctorClasses = basicCtorClasses;
			ctorArgs = basicCtorArgs;
		}
		try {
			for (;;) {
				try {
					ctor = valClass.getConstructor(ctorClasses);
					break;
				} catch (NoSuchMethodException e) {
					dataClass = dataClass.getSuperclass();
					if (dataClass == null)
						throw e;
					ctorClasses[0] = dataClass;
				}
			}
			Object o = ctor.newInstance(ctorArgs);
			return (ISimpleAttrValue) o;
		} catch (SecurityException e) {
			throw new IdASException(e);
		} catch (NoSuchMethodException e) {
			throw new IdASException(e);
		} catch (IllegalArgumentException e) {
			throw new IdASException(e);
		} catch (InstantiationException e) {
			throw new IdASException(e);
		} catch (IllegalAccessException e) {
			throw new IdASException(e);
		} catch (InvocationTargetException e) {
			throw new IdASException(e);
		}
	}

	private static void _initTypeToBasicMap() {
		_typeToBasicMap = new Hashtable();
		_typeToBasicMap.put(ITypedValue.STRING_TYPE_URI, BasicValueString.class);
		_typeToBasicMap.put(ITypedValue.NORMALIZEDSTRING_TYPE_URI, BasicValueNormalizedString.class); 
		_typeToBasicMap.put(ITypedValue.BOOLEAN_TYPE_URI, BasicValueBoolean.class); 
		_typeToBasicMap.put(ITypedValue.DECIMAL_TYPE_URI, BasicValueDecimal.class); 
		_typeToBasicMap.put(ITypedValue.INTEGER_TYPE_URI, BasicValueInteger.class); 
		_typeToBasicMap.put(ITypedValue.NONNEGATIVEINTEGER_TYPE_URI, BasicValueNonNegativeInteger.class); 
		_typeToBasicMap.put(ITypedValue.POSITIVEINTEGER_TYPE_URI, BasicValuePositiveInteger.class); 
		_typeToBasicMap.put(ITypedValue.NONPOSITIVEINTEGER_TYPE_URI, BasicValueNonPositiveInteger.class); 
		_typeToBasicMap.put(ITypedValue.NEGATIVEINTEGER_TYPE_URI, BasicValueNegativeInteger.class); 
		_typeToBasicMap.put(ITypedValue.FLOAT_TYPE_URI, BasicValueFloat.class); 
		_typeToBasicMap.put(ITypedValue.DOUBLE_TYPE_URI, BasicValueDouble.class); 
		_typeToBasicMap.put(ITypedValue.LONG_TYPE_URI, BasicValueLong.class); 
		_typeToBasicMap.put(ITypedValue.INT_TYPE_URI, BasicValueInt.class); 
		_typeToBasicMap.put(ITypedValue.SHORT_TYPE_URI, BasicValueShort.class); 
		_typeToBasicMap.put(ITypedValue.BYTE_TYPE_URI, BasicValueByte.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDLONG_TYPE_URI, BasicValueUnsignedLong.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDINT_TYPE_URI, BasicValueUnsignedInt.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDSHORT_TYPE_URI, BasicValueUnsignedShort.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDBYTE_TYPE_URI, BasicValueUnsignedByte.class); 
		_typeToBasicMap.put(ITypedValue.BASE64BINARY_TYPE_URI, BasicValueBase64Binary.class); 
		_typeToBasicMap.put(ITypedValue.HEXBINARY_TYPE_URI, BasicValueHexBinary.class); 
		_typeToBasicMap.put(ITypedValue.DATETIME_TYPE_URI, BasicValueDateTime.class); 
		_typeToBasicMap.put(ITypedValue.TIME_TYPE_URI, BasicValueTime.class); 
		_typeToBasicMap.put(ITypedValue.DATE_TYPE_URI, BasicValueDate.class); 
		_typeToBasicMap.put(ITypedValue.GYEARMONTH_TYPE_URI, BasicValueGYearMonth.class); 
		_typeToBasicMap.put(ITypedValue.GYEAR_TYPE_URI, BasicValueGYear.class); 
		_typeToBasicMap.put(ITypedValue.GMONTHDAY_TYPE_URI, BasicValueGMonthDay.class); 
		_typeToBasicMap.put(ITypedValue.GDAY_TYPE_URI, BasicValueGDay.class); 
		_typeToBasicMap.put(ITypedValue.GMONTH_TYPE_URI, BasicValueGMonth.class); 
		_typeToBasicMap.put(ITypedValue.ANYURI_TYPE_URI, BasicValueAnyURI.class); 
		_typeToBasicMap.put(ITypedValue.TOKEN_TYPE_URI, BasicValueToken.class); 
		_typeToBasicMap.put(ITypedValue.LANGUAGE_TYPE_URI, BasicValueLanguage.class); 
		_typeToBasicMap.put(ITypedValue.NMTOKEN_TYPE_URI, BasicValueNMTOKEN.class); 
		_typeToBasicMap.put(ITypedValue.NAME_TYPE_URI, BasicValueName.class); 
		_typeToBasicMap.put(ITypedValue.NCNAME_TYPE_URI, BasicValueNCName.class);
	}

	public IDigitalSubject addSubject(URI type, String subjectID) throws IdASException, InvalidTypeException, InvalidSubjectIDException, SubjectExistsException {
		throw new NotImplementedException();
	}

	public IMetadata addMetadata(URI type) throws IdASException, InvalidTypeException {
		throw new NotImplementedException();
	}

	public IComplexAttrValue buildComplexAttrValue(URI type) throws IdASException, InvalidTypeException {
		throw new NotImplementedException();
	}

	public IDigitalSubject addSubject(IDigitalSubject copyFrom) throws IdASException, SubjectExistsException {
		throw new NotImplementedException();
	}

	public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
		throw new NotImplementedException();
	}

	public void applyUpdates() throws IdASException {
		throw new NotImplementedException();
	}

	public void cancelUpdates() throws IdASException {
		throw new NotImplementedException();
	}

	public IAuthNAttributesMaterials buildAuthNAttributesMaterials() throws IdASException {
		return new BasicAuthNAttributesMaterials(null, this);
	}

	public IAttribute buildAttribute(URI attrID) throws IdASException {
		return new BasicAttribute(attrID, (Iterator)null, null, this);
	}

	public void updateNotification(SubjectNotification subjectNotif) throws IdASException {
		String subjectID = subjectNotif.getSubject().getSubjectID();
		_log.debug("Received subject update notifcation - " + subjectID);
		Vector updateNotifs = (Vector)_updateTable.get(subjectID);
		if (updateNotifs == null)
			updateNotifs = new Vector();
		updateNotifs.add(subjectNotif);

		_updateTable.put(subjectID, updateNotifs);
	}

	protected Hashtable getUpdateList()
	{
		return _updateTable;
	}

}
