/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IMetadataModel;

/**
 * Implements {@link IMetadata} 
 *
 */
public class BasicMetadata implements IMetadata  {
	private ITypedValue _value;
	private URI _ID;
	private IMetadataContainer _container;

	
	public BasicMetadata(URI metadataID, IMetadataContainer container) throws IdASException {
		_ID = metadataID;
		_container = container;
	}

	public BasicMetadata(IMetadata copyFrom, IMetadataContainer container) throws IdASException {
		_value = new BasicSimpleValue(copyFrom.getType(), copyFrom.getData());
		_container = container;
	}

	public String getCanonical() throws IdASException {
		return getValue().getCanonical();
	}

	public Object getData() throws IdASException {
		return getValue().getData();
	}

	public URI getID() throws IdASException {
		return _ID;
	}

	public String getLexical() throws IdASException {
		return getValue().getLexical();
	}

	public IMetadataModel getModel() throws IdASException {
		throw new NotImplementedException();
	}

	public URI getType() throws IdASException {
		return getValue().getType();
	}

	public void remove() throws IdASException {
		if (_container != null) {
			// TODO
//			_container.removeMetadata(this);
		}
	}

	public void setData(Object data) throws IdASException {
		// TODO Auto-generated method stub
		
	}

	private ITypedValue getValue() throws IdASException {
		if (_value != null)
			return _value;
		throw new IdASException("No value set");
	}
	
}
