/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.nio.ByteBuffer;

import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

/**
 *
 */
public class BasicValueBase64Binary extends AbstractSimpleValue {
	
	public BasicValueBase64Binary(ByteBuffer data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.BASE64BINARY_TYPE_URI, data, container);
	}
	
	/**
	 * Uses the specified byte array to build this object.
	 * @param bytes array of bytes used to back this object
	 * @throws IdASException 
	 */
	public BasicValueBase64Binary(byte[] bytes, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.BASE64BINARY_TYPE_URI, ByteBuffer.wrap(bytes), container);
	}

	/**
	 * Uses the specified byte array to build this object.
	 * @param base64String base 64 encoded string used to build this object
	 * @throws IdASException 
	 */
	public BasicValueBase64Binary(String base64String, IAttributeValueContainer container) throws IdASException {
		super();
		Base64 b64 = new Base64();
		super.init(ITypedValue.BASE64BINARY_TYPE_URI, ByteBuffer.wrap(b64.decode(base64String)), container);
	}

	public String getLexical() throws IdASException {
		return getCanonical();
	}

	/**
	 * TODO (Impl): make sure this meets the canonical rules for xsd:base64Binary
	 */
	public String getCanonical() throws IdASException {
		Base64 encoder = new Base64();
/*
		System.out.println("byte array len: " + _data.array().length);
		System.out.println("byte array bytes:");
		
		for (byte b : _data.array())
		{
			System.out.print(b);
		}
		System.out.println();
		String s = encoder.encodeBytes(_data.array());
		System.out.println("Converted to: " + s);
		
		System.out.println("baseline byte array = 'A','B','C'");
		byte[] b = {'A','B','C'};
		s = encoder.encodeBytes(b);
		System.out.println("Baseline converted to: " + s);
*/		
		return encoder.encodeBytes(((ByteBuffer)getData()).array());
	}
}
