/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueDate extends BasicValueDateTime implements ISimpleAttrValue {
	
	public BasicValueDate(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.DATE_TYPE_URI, value, container);
	}

	protected String[] _getAllowedFormats() {
		//'-'? yyyy '-' mm '-' dd (zzzzzz)?		
		return new String[]{"yyyy-MM-dd'Z'",
							"yyyy-MM-ddZ"};
	}

	public URI getType() throws IdASException {
		return ITypedValue.DATE_TYPE_URI;
	}
}
