/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueShort extends AbstractSimpleValue implements ISimpleAttrValue {
	
	public BasicValueShort(Short value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.SHORT_TYPE_URI, value, container);
	}

	public BasicValueShort(String value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.SHORT_TYPE_URI, new Short(value), container);
	}

	public BasicValueShort(short value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.SHORT_TYPE_URI, new Short(value), container);
	}
}
