/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueSubjectRelationship extends AbstractComplexValue
		implements IComplexAttrValue {

	public static final URI CONTEXT_REF_TYPE_URI = URI.create(IAttributeValue.BASE_OWL_URI + "contextURI");
	public static final URI SUBJECT_CUID_TYPE_URI = URI.create(IAttributeValue.BASE_OWL_URI + "subjectCUID");
	private URI _type = null;

	public BasicValueSubjectRelationship(URI type, IAttributeValueContainer container) throws IdASException {
		super();
		_type = type;
	}

	/**
	 * 
	 * @param type
	 * @param attrs Contains {@link IAttribute}s
	 * @throws IdASException 
	 */
	public BasicValueSubjectRelationship(URI type, Iterator attrs, IAttributeValueContainer container) throws IdASException {
		super(attrs, container);
		_type = type;
	}

	/**
	 * 
	 * @param type Type of SubjectRelationship (typically sub-type of SubjectRelationship) 
	 * @param contextRef reference to the Context holding the referred-to {@link IDigitalSubject}
	 * @param cuid Contextually Unique Identifier of the referred-to {@link IDigitalSubject}.
	 */
	public BasicValueSubjectRelationship(URI type, URI contextRef, String cuid, IAttributeValueContainer container) throws IdASException {
		super();
		IAttribute attr; 

		attr = addAttribute(CONTEXT_REF_TYPE_URI);
		attr.addSimpleValue(ITypedValue.ANYURI_TYPE_URI, contextRef);

		attr = addAttribute(SUBJECT_CUID_TYPE_URI);
		attr.addSimpleValue(ITypedValue.NORMALIZEDSTRING_TYPE_URI, cuid); 
		_type = type;
	}

	public URI getType() throws IdASException {
		return _type;
	}

	public Object getData() throws IdASException {
		return null;
	}
}
