/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;



/**
 * Implements {@link IHasMetadata} using a {@link Hashtable}.  This is used by other basic implementations which implement subinterfaces of {@link org.eclipse.higgins.idas.api.IHasMetadata}.  
 *
 */
public class BasicMetadataSet implements IHasMetadata, IMetadataContainer {
	private Hashtable _metas;
	private IMetadataContainer _metaContainer = this;

	public BasicMetadataSet() {
		_metas = new Hashtable();
	}

	/**
	 * 
	 * @param metaSet Contains {@link IMetadata}s
	 */
	public BasicMetadataSet(Iterator metaSet, IMetadataContainer container) throws IdASException {
		this();
		if (container != null) {
			_metaContainer = container;
		}
		if (metaSet != null)	{
			while (metaSet.hasNext()) {
				addMetadata((IMetadata)metaSet.next());
			}
		}
	}

	public Iterator getMetadataSet() throws IdASException {
		return _metas.values().iterator();
	}

	public IMetadata getMetadata(URI metadataID) throws IdASException {
		return (IMetadata) _metas.get(metadataID);
	}

	public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
		IMetadata meta = new BasicMetadata(metadataID, _metaContainer);
		insertMetadata(meta);
		return meta;
	}

	public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
		IMetadata meta = new BasicMetadata(copyFrom, _metaContainer, null);
		insertMetadata(meta);
		return meta;
	}

	/**
	 * Internal method which inserts the passed metadata.
	 * Does not make a copy.
	 * @param meta
	 * @throws IdASException
	 */
	protected void insertMetadata(IMetadata meta) throws IdASException {
		_metas.put(meta.getMetaID(), meta);
	}
	
	protected void removeMetadata(IMetadata meta) throws IdASException {
		_metas.remove(meta.getMetaID());
	}

	public void updateNotification(MetadataNotification metaNotif) throws IdASException {
		if (_metaContainer != this) {
			_metaContainer.updateNotification(metaNotif);
		}
	}

	public boolean equals(IHasMetadata metadataSet) throws IdASException {
		int localCount = 0, metadataCount = 0;
		Iterator iter = metadataSet.getMetadataSet();
		while (iter.hasNext()) {
			IMetadata meta = (IMetadata)iter.next();
			if (this._contains(meta) == false) {
				return false;
			}
			metadataCount++;
		}
		
		// everything we were given was found, make sure the sizes match
		iter = this.getMetadataSet();
		while (iter.hasNext()) {
			iter.next();
			localCount++;
		}
		return localCount == metadataCount;
	}

	private boolean _contains(IMetadata meta) throws IdASException {
		Iterator iter = this.getMetadataSet();
		while (iter.hasNext()) {
			if (((IMetadata)iter.next()).equals(meta))
				return true;
		}
		return false;
	}
	
}
