/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.math.BigInteger;
import java.net.URI;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * TODO (Impl): make sure getCanonical() meets the canonical rules for xsd:integer. Nothing in the BigInteger Javadoc leads me to believe it's incorrect.
 */
public class BasicValueInteger extends AbstractSimpleValue implements ISimpleAttrValue {
	
	public BasicValueInteger(BigInteger value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.INTEGER_TYPE_URI, value, container);
	}

	public BasicValueInteger(String value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.INTEGER_TYPE_URI, new BigInteger(value), container);
	}

	protected BasicValueInteger(URI type, BigInteger data, IAttributeValueContainer container) throws IdASException {
		super();
		validate(data);
		super.init(type, data, container);
	}

	protected BasicValueInteger() throws IdASException {
		// TODO Auto-generated constructor stub
	}
	
	protected void validate(BigInteger value) {
		return;
	}
}
