/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *    Tom Doman
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IMetadata;

public class MetadataNotification
{
	/**
	 * This action is set when the {@link IMetadata} returned by {@link #getMeta()} was added
	 */
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_ADD";
	/**
	 * This action is set when the {@link IMetadata} returned by {@link #getMeta()} was removed
	 */
	public static final String UPDATE_REMOVE = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_REMOVE";
	/**
	 * This action is set when there is a {@link MetadataValueNotification} to be returned by {@link #getMetadataValueNotification()}
	 * This signifies that a value of this metadata was updated.
	 */
	public static final String UPDATE_VALUE_NOTIFY = "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_VALUE_NOTIFY";

	private IMetadata _meta;
	private String _action;
	private MetadataValueNotification _metaValNotif;

	/**
	 * 
	 * @param meta
	 * @param action
	 * @param metaValNotif
	 */
	public MetadataNotification(
		IMetadata meta,
		String action,
		MetadataValueNotification metaValNotif)
	{
		_meta = meta;
		_action = action;
		_metaValNotif = metaValNotif;
	}

	/**
	 * 
	 * @return the IMetadata being added or removed when the action is set to {@link #UPDATE_ADD} or {@link #UPDATE_REMOVE}
	 */
	public IMetadata getMeta()
	{
		return _meta;
	}

	/**
	 * 
	 * @return one of: {@link #UPDATE_ADD}, {@link #UPDATE_REMOVE}, {@link #UPDATE_VALUE_NOTIFY} 
	 */
	public String getAction()
	{
		return _action;
	}	

	/**
	 * 
	 * @return an MetadataValueNotification when the action is set to {@link #UPDATE_VALUE_NOTIFY}.
	 */
	public MetadataValueNotification getMetadataValueNotification()
	{
		return _metaValNotif;
	}

}
