/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.nio.ByteBuffer;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

/**
 *
 */
public class BasicValueHexBinary extends AbstractSimpleValue implements ISimpleAttrValue {
	
	public BasicValueHexBinary(ByteBuffer data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.HEXBINARY_TYPE_URI, data, container);
	}

	public BasicValueHexBinary(String data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.HEXBINARY_TYPE_URI, _fromHexString(data), container);
	}

	/**
	 * Uses the specified byte array to build this object.
	 * @param bytes array of bytes used to back this object
	 * @throws IdASException 
	 */
	public BasicValueHexBinary(byte[] bytes, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.HEXBINARY_TYPE_URI, ByteBuffer.wrap(bytes), container);
	}

	public String getLexical() throws IdASException {
		return _toHexString();
	}

	/**
	 * TODO (Impl): make sure this meets the canonical rules for xsd:base64Binary
	 */
	public String getCanonical() throws IdASException {
		return _toHexString().toUpperCase();
	}

	private String _toHexString() throws IdASException {
		byte[] array = ((ByteBuffer)getData()).array();
		StringBuffer sb = new StringBuffer(array.length * 2);  
		for (int iLoop = 0; iLoop < array.length; iLoop++) {
			sb.append(Integer.toHexString(array[iLoop]));
		}
		return sb.toString();
	}

	private ByteBuffer _fromHexString(String hexString) {
	    byte bytes[] = new byte[hexString.length() / 2];
	    for(int idx = 0; idx < bytes.length; idx++) {
	        bytes[idx] = (byte)Integer.parseInt(hexString.substring(idx * 2, (idx * 2) + 2), 16);
	    }
	    return ByteBuffer.wrap(bytes);
	}
}
