/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.math.BigInteger;
import java.net.URI;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueUnsignedInt extends BasicValueUnsignedLong implements ISimpleAttrValue {
	
	public BasicValueUnsignedInt(BigInteger value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.UNSIGNEDINT_TYPE_URI, value, container);
	}

	public BasicValueUnsignedInt(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.UNSIGNEDINT_TYPE_URI, new BigInteger(value), container);
	}

	public BasicValueUnsignedInt(URI type, BigInteger value, IAttributeValueContainer container) throws IdASException {
		super(type, value, container);
	}

	protected BigInteger _maxInclusive() {
		return new BigInteger("4294967295"); 
	}

}
