/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IMetadataValue;

public class MetadataValueNotification {
	/**
	 * This action is set when the {@link IMetadataValue} returned by {@link #getMetadataValue()} was added
	 */
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_ADD";
	/**
	 * This action is set when the {@link IMetadataValue} returned by {@link #getMetadataValue()} was removed
	 */
	public static final String UPDATE_REMOVE = "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_REMOVE";
	/**
	 * This action is set when the {@link Object} returned by {@link #getOldValueData()} was replaced.
	 * This implies that this metadata value is simple, and signifies that the data in this simple metadata
	 * value was set (or reset). The old value data is returned by {@link #getOldValueData()}, 
	 * and the new value data exists in the {@link ISimpleMetaValue#getData()} returned by {@link #getMetadataValue()}.
	 * The old value data will be null in the event that the data is being set for the first time. 
	 */
	public static final String UPDATE_SET_DATA = "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_SET_DATA";
	/**
	 * This action is set when there is a {@link MetadataNotification} to be returned by {@link #getMetadataNotification()}
	 * This implies that this metadata value is complex, and signifies that a sub-element of this complex metadata value was updated.
	 */
	public static final String UPDATE_METADATA_NOTIFY = "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_METADATA_NOTIFY";

	private IMetadataValue _metaVal;
	private String _action;
	private Object _oldValData;
	private MetadataNotification _metaNotif;
	
	/**
	 * 
	 * @param metaVal
	 * @param action
	 * @param oldValData
	 */
	public MetadataValueNotification(
		IMetadataValue metaVal,
		String action,
		Object oldValData)
	{
		_metaVal = metaVal;
		_action = action;
		_oldValData = oldValData;
	}
	
	/**
	 * 
	 */
	public IMetadataValue getMetadataValue()
	{
		return _metaVal;
	}

	/**
	 */
	public String getAction()
	{
		return _action;
	}

	/**
	 */
	public Object getOldValueData()
	{
		return _oldValData;
	}
	
	public MetadataNotification getMetadataNotification() {
		return _metaNotif;
	}
}
