/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicEntityModel;
import org.eclipse.higgins.idas.spi.IAttributeContainer;

public abstract class BasicEntity
implements IEntity,
IAttributeContainer {
    private IContext context;
    private String entityId;
    private URI type;
    private BasicAttributeSet attrs;
    private BasicEntityModel model;

    public BasicEntity(IContext context) throws IdASException {
        this(context, null, null, null);
    }

    public BasicEntity(IContext context, URI type, String entityId) throws IdASException {
        this(context, type, entityId, null);
    }

    public BasicEntity(IContext context, URI type, String entityId, Iterator attributes) throws IdASException {
        this.context = context;
        this.type = type;
        this.entityId = entityId;
        this.attrs = new BasicAttributeSet(attributes, this, context);
        this.model = new BasicEntityModel(type);
    }

    public IContext getContext() throws IdASException {
        return this.context;
    }

    public IEntityModel getModel() throws IdASException {
        if (this.model == null) {
            throw new IdASModelException("No model exists for this context");
        }
        return this.model;
    }

    public URI getEntityType() throws IdASException {
        return this.type;
    }

    public String getEntityID() throws IdASException {
        return this.entityId;
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this.attrs.addAttribute(copyFrom);
    }

    public IAttribute addAttribute(URI type) throws IdASException, InvalidTypeException {
        return this.attrs.addAttribute(type);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this.attrs.getAttribute(attrID);
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this.attrs.getSingleValuedAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this.attrs.getAttributes();
    }

    protected BasicAttributeSet getBasicAttributeSet() {
        return this.attrs;
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this.attrs.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this.attrs.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this.attrs.removeAttributeValue(attr);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this.attrs.equals(attributes);
    }
}

