/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicSimpleValue  extends AbstractSimpleValue implements ITypedValue {
	
	public static final String XML_TYPE_STR = "any";
	public static final String OWL_TYPE_STR = XML_TYPE_STR + ITypedValue.OWL_TYPE_SUFFIX;
	public static final String ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + OWL_TYPE_STR;
	public static final String ATTR_VALUE_TYPE_URI_STR = ITypedValue.BASE_XML_SCHEMA_URI + XML_TYPE_STR;

	public BasicSimpleValue(URI type, Object value) throws IdASException {
		super();
		super.init(type, value, null);
	}

	public BasicSimpleValue(URI type, Object value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(type, value, container);
	}

	public BasicSimpleValue(URI type, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(type, null, container);
	}

}
