/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueDateTime extends AbstractSimpleValue implements ISimpleAttrValue
{
	private int _formatUsed;
	
	public BasicValueDateTime(Date data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.DATETIME_TYPE_URI, data, container);
	}

	public BasicValueDateTime(String data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.DATETIME_TYPE_URI, _parseString(data), container);
	}
	
	protected BasicValueDateTime(URI type, Date data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(type, data, container);
	}

	protected BasicValueDateTime(URI type, String data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(type, _parseString(data), container);
	}
	
	public String getLexical() throws IdASException {
		SimpleDateFormat sdf = new SimpleDateFormat(_getAllowedFormats()[_formatUsed]);
		return sdf.format((Date)getData());
	}

	public String getCanonical() throws IdASException {
		SimpleDateFormat sdf = new SimpleDateFormat(_getAllowedFormats()[0]);
		return sdf.format((Date)getData());
	}

	private Date _parseString(String value) throws IdASException {
		SimpleDateFormat sdf = new SimpleDateFormat();
		String[] formats = _getAllowedFormats();
		Date date = null;
		for (_formatUsed = 0; _formatUsed < formats.length; _formatUsed++) {
			try {
				sdf.applyPattern(formats[_formatUsed]);
				date = sdf.parse(value);
			} catch(java.text.ParseException e) {
				// try next pattern
				continue;
			}
			break;
		}
		if (date == null)
			throw new IdASException("Unable to parse date value: " + value);
		return date;
	}
	
	/**
	 * @return a String array of {@link java.text.SimpleDateFormat} 
	 * 			Date and Time Pattern strings where the first string 
	 * 			represents the canonical representation and subsequent 
	 * 			strings represent other lexical representations 
	 */
	protected String[] _getAllowedFormats() {
		//'-'? yyyy '-' mm '-' dd 'T' hh ':' mm ':' ss ('.' s+)? (zzzzzz)?		
		return new String[]{"yyyy-MM-dd'T'HH:mm:ss.S'Z'",
							"yyyy-MM-dd'T'HH:mm:ss'Z'",
							"yyyy-MM-dd'T'HH:mm:ss.SZ",							
							"yyyy-MM-dd'T'HH:mm:ssZ"};
	}
}
