/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueInt extends AbstractSimpleValue implements ISimpleAttrValue {
	
	public BasicValueInt(Integer value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.INT_TYPE_URI, value, container);
	}

	public BasicValueInt(String value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.INT_TYPE_URI, new Integer(value), container);
	}

	public BasicValueInt(int value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.INT_TYPE_URI, new Integer(value), container);
	}
}
