/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.util.Date;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueTime extends BasicValueDateTime implements ISimpleAttrValue {
	
	public BasicValueTime(Date value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.TIME_TYPE_URI, value, container);
	}

	public BasicValueTime(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.TIME_TYPE_URI, value, container);
	}

	protected String[] _getAllowedFormats() {
		//hh ':' mm ':' ss ('.' sss)? (zzzzzz)?		
		return new String[]{"HH:mm:ss.SSS'Z'",
							"HH:mm:ss'Z'",
							"HH:mm:ss.SSSZ",							
							"HH:mm:ssZ"};
	}
}
