/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;

public class ComplexValueEntityWrapper implements IComplexAttrValue {
	private IEntity entity;
	
	public ComplexValueEntityWrapper (IEntity entity) {
		this.entity = entity;
	}

	public boolean equals(IAttributeValue value) throws IdASException {
		return entity.equals(value);
	}

	public URI getDataType() throws IdASException {
		return entity.getEntityType();
	}

	public URI getValueType() throws IdASException {
		return entity.getModel().getType();
	}

	public boolean isSimple() throws IdASException {
		return false;
	}

	public void remove() throws IdASException {
		entity.remove();
	}

	public IAttribute addAttribute(URI attrID) throws IdASException,
			InvalidTypeException {
		return entity.addAttribute(attrID);
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
		return entity.addAttribute(copyFrom);
	}

	public boolean equals(IHasAttributes attributes) throws IdASException {
		return entity.equals(attributes);
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {
		return entity.getAttribute(attrID);
	}

	public Iterator getAttributes() throws IdASException {
		return entity.getAttributes();
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID)
			throws IdASException, NotSingleValuedAttributeException {
		return entity.getSingleValuedAttribute(attrID);
	}

	public void removeAttribute(URI attrID) throws IdASException {
		entity.removeAttribute(attrID);
	}

	public void removeAttributeValue(URI attrID, Object value)
			throws IdASException {
		entity.removeAttributeValue(attrID, value);
	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {
		entity.removeAttributeValue(attr);
	}

	public IEntityModel getModel() throws IdASException {
		return entity.getModel();
	}

}
