/*******************************************************************************
 * Copyright (c) 2007-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.model.IContextModel;

/**
 * Basic implementation of IContext.  
 * The intent of this class is to be used by Context Provider 
 * writers as a superclass for IContext instances.  The benefits of 
 * using this class are that you will pick up any convenience methods
 * as well as have the latest methods stubbed out such that when new
 * methods are added to IContext and implemented here, the subclass
 * will still compile.  
 *
 */
public class BasicContext extends BasicAttributeSet implements IContext, IEntityContainer, IAttributeContainer
{
	private Log	 log = LogFactory.getLog(BasicContext.class.getName());
	private static Hashtable _typeToBasicMap = new Hashtable();
	/**
	 * This is a hashtable where the keys are entityIDs and the values are vectors of EntityNotifications
	 */
	private Hashtable _updateTable = new Hashtable();

	public BasicContext() throws IdASException {
		super();
	}
	
//TODO, get/process attr notifs for this context

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#close()
	 */
	public void close() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#exportData(java.lang.String, java.lang.String)
	 */
	public String exportData(String filter, String representationFormat)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getContextModel()
	 */
	public IContextModel getContextModel() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getContextID()
	 */
	public URI getContextID() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getSchema()
	 */
	public String getSchema() throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getEntity(java.lang.String)
	 */
	public IEntity getEntity(String entityID) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getEntity(java.lang.String, java.lang.Iterable)
	 */
	public IEntity getEntity(String entityID,
			Iterator attrSelectionList) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getEntities(org.eclipse.higgins.idas.api.IFilter)
	 */
	public Iterator getEntities(IFilter filter)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#getEntities(org.eclipse.higgins.idas.api.IFilter, java.lang.Iterable)
	 */
	public Iterator getEntities(IFilter filter,
			Iterator attrs) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#importData(java.lang.String, java.lang.String)
	 */
	public void importData(String filter, String representationFormat)
			throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#isOpen(java.lang.Object)
	 */
	public boolean isOpen(Object identity) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#open(java.lang.Object)
	 */
	public String open(Object authentication) throws IdASException,
			ContextOpenException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#setSchema(java.lang.String)
	 */
	public void setSchema(String schema) throws IdASException {
		throw new NotImplementedException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContext#verifyEntityAttributes(java.lang.String, java.lang.Iterable)
	 */
	public boolean verifyEntityAttributes(String entityID,
			Iterator attributes) throws IdASException {
		throw new NotImplementedException();
	}

	public IFilterAttributeAssertion buildAttributeAssertion() throws IdASException {
		return new BasicFilterAttributeAssertion();
	}

	public IFilterEntityIDAssertion buildEntityIDAssertion() throws IdASException {
		return new BasicFilterEntityIDAssertion();
	}

	public IFilter buildFilter() throws IdASException {
		return new BasicFilter();
	}

	public IFilterEntityTypeAssertion buildEntityTypeAssertion() throws IdASException {
		return new BasicFilterEntityTypeAssertion();
	}

	public ISimpleAttrValue buildSimpleAttrValue(URI type, Object data) throws IdASException {
		return createSimpleValue(type, data, null);
	}

	public static ISimpleAttrValue createSimpleValue(URI type, Object data, IAttributeValueContainer container) throws IdASException {
		_initTypeToBasicMap();
		Class valClass = (Class) _typeToBasicMap.get(type);
		Class dataClass = data.getClass();
		Class ctorClasses[] = {dataClass, IAttributeValueContainer.class};
		Object ctorArgs[] = {data, container};
		Constructor ctor = null;
		if (valClass == null) {
			Class basicCtorClasses[] = {URI.class, Object.class, IAttributeValueContainer.class};
			Object basicCtorArgs[] = {type, data, container};
			valClass = BasicSimpleValue.class;
			ctorClasses = basicCtorClasses;
			ctorArgs = basicCtorArgs;
		}
		try {
			for (;;) {
				try {
					ctor = valClass.getConstructor(ctorClasses);
					break;
				} catch (NoSuchMethodException e) {
					dataClass = dataClass.getSuperclass();
					if (dataClass == null)
						throw e;
					ctorClasses[0] = dataClass;
				}
			}
			Object o = ctor.newInstance(ctorArgs);
			return (ISimpleAttrValue) o;
		} catch (SecurityException e) {
			throw new IdASException(e);
		} catch (NoSuchMethodException e) {
			throw new IdASException(e);
		} catch (IllegalArgumentException e) {
			throw new IdASException(e);
		} catch (InstantiationException e) {
			throw new IdASException(e);
		} catch (IllegalAccessException e) {
			throw new IdASException(e);
		} catch (InvocationTargetException e) {
			throw new IdASException(e);
		}
	}

	private static void _initTypeToBasicMap() {
		_typeToBasicMap = new Hashtable();
		_typeToBasicMap.put(ITypedValue.STRING_TYPE_URI, BasicValueString.class);
		_typeToBasicMap.put(ITypedValue.NORMALIZEDSTRING_TYPE_URI, BasicValueNormalizedString.class); 
		_typeToBasicMap.put(ITypedValue.BOOLEAN_TYPE_URI, BasicValueBoolean.class); 
		_typeToBasicMap.put(ITypedValue.DECIMAL_TYPE_URI, BasicValueDecimal.class); 
		_typeToBasicMap.put(ITypedValue.INTEGER_TYPE_URI, BasicValueInteger.class); 
		_typeToBasicMap.put(ITypedValue.NONNEGATIVEINTEGER_TYPE_URI, BasicValueNonNegativeInteger.class); 
		_typeToBasicMap.put(ITypedValue.POSITIVEINTEGER_TYPE_URI, BasicValuePositiveInteger.class); 
		_typeToBasicMap.put(ITypedValue.NONPOSITIVEINTEGER_TYPE_URI, BasicValueNonPositiveInteger.class); 
		_typeToBasicMap.put(ITypedValue.NEGATIVEINTEGER_TYPE_URI, BasicValueNegativeInteger.class); 
		_typeToBasicMap.put(ITypedValue.FLOAT_TYPE_URI, BasicValueFloat.class); 
		_typeToBasicMap.put(ITypedValue.DOUBLE_TYPE_URI, BasicValueDouble.class); 
		_typeToBasicMap.put(ITypedValue.LONG_TYPE_URI, BasicValueLong.class); 
		_typeToBasicMap.put(ITypedValue.INT_TYPE_URI, BasicValueInt.class); 
		_typeToBasicMap.put(ITypedValue.SHORT_TYPE_URI, BasicValueShort.class); 
		_typeToBasicMap.put(ITypedValue.BYTE_TYPE_URI, BasicValueByte.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDLONG_TYPE_URI, BasicValueUnsignedLong.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDINT_TYPE_URI, BasicValueUnsignedInt.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDSHORT_TYPE_URI, BasicValueUnsignedShort.class); 
		_typeToBasicMap.put(ITypedValue.UNSIGNEDBYTE_TYPE_URI, BasicValueUnsignedByte.class); 
		_typeToBasicMap.put(ITypedValue.BASE64BINARY_TYPE_URI, BasicValueBase64Binary.class); 
		_typeToBasicMap.put(ITypedValue.HEXBINARY_TYPE_URI, BasicValueHexBinary.class); 
		_typeToBasicMap.put(ITypedValue.DATETIME_TYPE_URI, BasicValueDateTime.class); 
		_typeToBasicMap.put(ITypedValue.TIME_TYPE_URI, BasicValueTime.class); 
		_typeToBasicMap.put(ITypedValue.DATE_TYPE_URI, BasicValueDate.class); 
		_typeToBasicMap.put(ITypedValue.GYEARMONTH_TYPE_URI, BasicValueGYearMonth.class); 
		_typeToBasicMap.put(ITypedValue.GYEAR_TYPE_URI, BasicValueGYear.class); 
		_typeToBasicMap.put(ITypedValue.GMONTHDAY_TYPE_URI, BasicValueGMonthDay.class); 
		_typeToBasicMap.put(ITypedValue.GDAY_TYPE_URI, BasicValueGDay.class); 
		_typeToBasicMap.put(ITypedValue.GMONTH_TYPE_URI, BasicValueGMonth.class); 
		_typeToBasicMap.put(ITypedValue.ANYURI_TYPE_URI, BasicValueAnyURI.class); 
		_typeToBasicMap.put(ITypedValue.TOKEN_TYPE_URI, BasicValueToken.class); 
		_typeToBasicMap.put(ITypedValue.LANGUAGE_TYPE_URI, BasicValueLanguage.class); 
		_typeToBasicMap.put(ITypedValue.NMTOKEN_TYPE_URI, BasicValueNMTOKEN.class); 
		_typeToBasicMap.put(ITypedValue.NAME_TYPE_URI, BasicValueName.class); 
		_typeToBasicMap.put(ITypedValue.NCNAME_TYPE_URI, BasicValueNCName.class);
	}

	public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
		throw new NotImplementedException();
	}

	public IComplexAttrValue buildComplexAttrValue(URI type) throws IdASException, InvalidTypeException {
		throw new NotImplementedException();
	}

	public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
		throw new NotImplementedException();
	}

	public void applyUpdates() throws IdASException {
		throw new NotImplementedException();
	}

	public void cancelUpdates() throws IdASException {
		throw new NotImplementedException();
	}

	public IAuthNAttributesMaterials buildAuthNAttributesMaterials() throws IdASException {
		return new BasicAuthNAttributesMaterials(null, this);
	}

	public IAttribute buildAttribute(URI attrID) throws IdASException {
		return new BasicAttribute(attrID, (Iterator)null, null, this);
	}

	public void updateNotification(EntityNotification entityNotif) throws IdASException {
		String entityID = entityNotif.getEntity().getEntityID();
		log.debug("Received entity update notifcation - " + entityID);
		Vector updateNotifs = (Vector)_updateTable.get(entityID);
		if (updateNotifs == null)
			updateNotifs = new Vector();
		updateNotifs.add(entityNotif);

		_updateTable.put(entityID, updateNotifs);
	}

	protected Hashtable getUpdateList()
	{
		return _updateTable;
	}

}
