/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicEntityModel;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public abstract class AbstractComplexValue
extends BasicAttributeSet
implements IComplexAttrValue {
    private IAttributeValueContainer container;
    private IEntityModel model;
    private URI type;

    public AbstractComplexValue(URI type, Iterator attrs, IAttributeValueContainer container) throws IdASException {
        super(attrs, null, null);
        this.container = container;
        this.type = type;
        this.model = new BasicEntityModel(type);
    }

    public boolean isSimple() throws IdASException {
        return false;
    }

    public void remove() throws IdASException {
        if (this.container != null) {
            AttributeValueNotification attrValueNotif = new AttributeValueNotification((IAttributeValue)this, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE", null);
            this.container.updateNotification(attrValueNotif);
        }
    }

    protected URI getType() throws IdASException {
        return this.type;
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        if (value.isSimple()) {
            return false;
        }
        IComplexAttrValue val = (IComplexAttrValue)value;
        if (val.getModel().getType() != this.getModel().getType()) {
            return false;
        }
        return this.equals((IHasAttributes)val);
    }

    public IEntityModel getModel() throws IdASException {
        return this.model;
    }

    public URI getValueType() throws IdASException {
        return this.getType();
    }
}

