/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicSimpleValueModel;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public abstract class AbstractSimpleValue
extends BasicAttributeSet
implements ISimpleAttrValue {
    private Object data;
    private IAttributeValueContainer container;
    private IAttributeSimpleValueModel model;

    protected void init(URI type, Object data, IAttributeValueContainer container) {
        this.data = data;
        this.container = container;
        this.model = new BasicSimpleValueModel(type);
    }

    public String getLexical() throws IdASException {
        Object data = this.getData();
        if (data == null) {
            throw new IdASException("Data not yet set on this object. DataType=" + this.getDataType() + ", Object=" + this.toString());
        }
        return data.toString();
    }

    public String getCanonical() throws IdASException {
        Object data = this.getData();
        if (data == null) {
            throw new IdASException("Data not yet set on this object. DataType=" + this.getDataType() + ", Object=" + this.toString());
        }
        return data.toString();
    }

    public boolean isSimple() throws IdASException {
        return true;
    }

    public URI getDataType() throws IdASException {
        IAttributeSimpleValueModel model = this.getModel();
        if (model == null) {
            throw new IdASException("Model not yet set on this object. DataType=" + this.getDataType() + ", Object=" + this.toString());
        }
        return model.getType();
    }

    public URI getValueType() throws IdASException {
        IAttributeSimpleValueModel model = this.getModel();
        if (model == null) {
            throw new IdASException("Model not yet set on this object. DataType=" + this.getDataType() + ", Object=" + this.toString());
        }
        return model.getType();
    }

    public Object getData() throws IdASException {
        return this.data;
    }

    public void setData(Object data) throws IdASException {
        if (this.container != null) {
            AttributeValueNotification attrValueNotif = new AttributeValueNotification((IAttributeValue)this, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_SET_DATA", this.data);
            this.container.updateNotification(attrValueNotif);
        }
        this.data = data;
    }

    public void remove() throws IdASException {
        if (this.container != null) {
            AttributeValueNotification attrValueNotif = new AttributeValueNotification((IAttributeValue)this, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE", null);
            this.container.updateNotification(attrValueNotif);
        }
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        if (!value.isSimple()) {
            return false;
        }
        ISimpleAttrValue val = (ISimpleAttrValue)value;
        if (this.getValueType() != val.getValueType()) {
            return false;
        }
        if (!this.equals((IHasAttributes)value)) {
            return false;
        }
        return this.getCanonical().equals(val.getCanonical());
    }

    public IAttributeSimpleValueModel getModel() throws IdASException {
        return this.model;
    }
}

