/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.UnhandledExtensionException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.common.DereferenceAttrValuesExtension;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.AttributeValueNotification;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicComplexValue;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicContextModel;
import org.eclipse.higgins.idas.spi.BasicSimpleValue;
import org.eclipse.higgins.idas.spi.ComplexValueEntityWrapper;
import org.eclipse.higgins.idas.spi.IAttributeContainer;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public class BasicAttribute
implements IAttribute,
IAttributeValueContainer,
IAttributeContainer {
    private Log log = LogFactory.getLog((String)(class$org$eclipse$higgins$idas$spi$BasicAttribute == null ? (class$org$eclipse$higgins$idas$spi$BasicAttribute = BasicAttribute.class$("org.eclipse.higgins.idas.spi.BasicAttribute")) : class$org$eclipse$higgins$idas$spi$BasicAttribute).getName());
    private URI _attrID;
    private Vector _values;
    private IAttributeContainer _container;
    private IContext _context;
    private BasicAttributeSet _metaAttrs;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$spi$BasicAttribute;

    public BasicAttribute(IAttribute copyFrom, IAttributeContainer container, IContext context) throws IdASException {
        this._init(copyFrom.getAttrID(), copyFrom.getValues(), copyFrom.getAttributes(), container, context);
    }

    public BasicAttribute(URI attrID, IAttributeValue value, IAttributeContainer container, IContext context) throws IdASException {
        if (value != null) {
            Vector<IAttributeValue> v = new Vector<IAttributeValue>(1);
            v.add(value);
            this._init(attrID, v.iterator(), null, container, context);
        } else {
            this._init(attrID, null, null, container, context);
        }
    }

    public BasicAttribute(URI attrID, Object data, IAttributeContainer container, IContext context) throws IdASException {
        IAttributeValueModel valueModel = this.getModel().getValueModel();
        URI valueType = valueModel.getType();
        ISimpleAttrValue value = BasicContext.createSimpleValue(valueType, data, this);
        if (value != null) {
            Vector<ISimpleAttrValue> v = new Vector<ISimpleAttrValue>(1);
            v.add(value);
            this._init(attrID, v.iterator(), null, container, context);
        } else {
            this._init(attrID, null, null, container, context);
        }
    }

    public BasicAttribute(URI attrID, Iterator values, IAttributeContainer container, IContext context) throws IdASException {
        this._init(attrID, values, null, container, context);
    }

    private void _init(URI attrID, Iterator values, Iterator metaSet, IAttributeContainer container, IContext context) throws IdASException {
        this._attrID = attrID;
        this._container = container;
        this._values = new Vector();
        this._context = context;
        if (values != null) {
            while (values.hasNext()) {
                this.addValue((IAttributeValue)values.next());
            }
        }
        this._metaAttrs = new BasicAttributeSet(metaSet, this, context);
    }

    private void _addValue(IAttributeValue val) throws IdASException {
        this._values.add(val);
        this.log.debug((Object)("Sending value add notification - " + val.getValueType()));
        AttributeValueNotification valueNotif = new AttributeValueNotification(val, "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD", null);
        this.updateNotification(valueNotif);
    }

    private boolean _containsValue(IAttributeValue value) throws IdASException {
        Iterator iter = this.getValues();
        boolean bRet = false;
        while (iter.hasNext()) {
            IAttributeValue localVal = (IAttributeValue)iter.next();
            if (!localVal.equals(value)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public URI getAttrID() throws IdASException {
        return this._attrID;
    }

    public Iterator getValues() throws IdASException {
        return this.getValues((DereferenceAttrValuesExtension)null);
    }

    public IAttributeModel getModel() throws IdASException {
        if (this._context != null) {
            return (IAttributeModel)this._context.getContextModel().getModel(this.getAttrID());
        }
        throw new NotImplementedException("No associated context to obtain model");
    }

    public IComplexAttrValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
        BasicComplexValue val = new BasicComplexValue(type, null, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public ISimpleAttrValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
        ISimpleAttrValue val = BasicContext.createSimpleValue(type, data, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public IAttributeValue addValue(URI type) throws IdASException, InvalidTypeException {
        Object ctxModel = this._context != null ? this._context.getContextModel() : new BasicContextModel();
        IModel valueModel = ctxModel.getModel(type);
        if (valueModel == null) {
            throw new IdASException("Context model (" + ctxModel.getClass() + ") returned no value model for " + type);
        }
        BasicAttributeSet val = valueModel instanceof IAttributeSimpleValueModel ? new BasicSimpleValue(type, null, this) : new BasicComplexValue(type, null, this);
        this._addValue((IAttributeValue)val);
        return val;
    }

    public IAttributeValue addValue(IAttributeValue copyFrom) throws IdASException {
        BasicAttributeSet val;
        if (copyFrom.isSimple()) {
            ISimpleAttrValue simpleCopyFrom = (ISimpleAttrValue)copyFrom;
            val = new BasicSimpleValue(simpleCopyFrom.getModel().getType(), simpleCopyFrom.getData(), this);
        } else {
            IComplexAttrValue complexCopyFrom = (IComplexAttrValue)copyFrom;
            val = new BasicComplexValue(complexCopyFrom.getModel().getType(), complexCopyFrom.getAttributes(), this);
        }
        this._addValue((IAttributeValue)val);
        return val;
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            AttributeNotification attrNotif = new AttributeNotification(this, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE", null, null);
            this.log.debug((Object)("Sending attribute remove notification - " + attrNotif.getAction() + ", " + attrNotif.getAttr().getAttrID().toString()));
            this._container.updateNotification(attrNotif);
        }
    }

    public boolean isSingleValued() {
        return false;
    }

    public void updateNotification(AttributeValueNotification attrValueNotif) throws IdASException {
        this.log.debug((Object)("Received attribute value notification - " + attrValueNotif.getAction() + ", " + attrValueNotif.getAttributeValue().toString()));
        this.log.debug((Object)("_containter " + (this._container != null ? this._container.toString() : "null")));
        if (this._container != null) {
            AttributeNotification attrNotif = new AttributeNotification(this, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY", attrValueNotif, null);
            this._container.updateNotification(attrNotif);
        }
        if (attrValueNotif.getAction() == "urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE") {
            this._values.remove(attrValueNotif.getAttributeValue());
        }
    }

    public void setContainer(IAttributeContainer container) {
        this._container = container;
    }

    public IAttributeContainer getContainer() {
        return this._container;
    }

    public boolean equals(IAttribute attr) throws IdASException {
        boolean bRet;
        if (attr.getAttrID() != this.getAttrID()) {
            bRet = false;
        } else {
            bRet = this.equals((IHasAttributes)attr);
            if (bRet) {
                Iterator iter = attr.getValues();
                while (iter.hasNext()) {
                    if (this._containsValue((IAttributeValue)iter.next())) continue;
                    bRet = false;
                    break;
                }
            }
        }
        return bRet;
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return this._metaAttrs.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this._metaAttrs.addAttribute(copyFrom);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this._metaAttrs.equals(attributes);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this._metaAttrs.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this._metaAttrs.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this._metaAttrs.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this._metaAttrs.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this._metaAttrs.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this._metaAttrs.removeAttributeValue(attr);
    }

    public void updateNotification(AttributeNotification attrNotif) throws IdASException {
        this._metaAttrs.updateNotification(attrNotif);
    }

    public Iterator getValues(IExtension[] extensions) throws IdASException {
        DereferenceAttrValuesExtension ext = null;
        if (extensions == null) {
            return this.getValues(ext);
        }
        for (int index = 0; index < extensions.length; ++index) {
            if (extensions[index].getID().compareTo((Object)URI.create("http://www.eclipse.org/higgins/idas/extension/derefattrvals")) != 0 && extensions[index].failIfUnsupported()) {
                throw new UnhandledExtensionException(extensions[index].getID() + "not supported");
            }
            if (ext != null) {
                throw new UnhandledExtensionException("multiple occurances of http://www.eclipse.org/higgins/idas/extension/derefattrvals not supported");
            }
            if (!(extensions[index] instanceof DereferenceAttrValuesExtension)) {
                throw new IdASException("Invalid extension");
            }
            ext = (DereferenceAttrValuesExtension)extensions[index];
        }
        return this.getValues(ext);
    }

    private Iterator getValues(DereferenceAttrValuesExtension ext) throws IdASException {
        Vector vals = (Vector)this._values.clone();
        if (ext != null) {
            for (int index = 0; index < vals.size(); ++index) {
                IAttributeValue val = (IAttributeValue)vals.elementAt(index);
                if (!ext.shouldDereference(this._attrID, val.getValueType())) continue;
                val = this.dereferenceValue(val);
                vals.setElementAt(val, index);
            }
        }
        return vals.iterator();
    }

    private IAttributeValue dereferenceValue(IAttributeValue val) throws IdASException {
        ISimpleAttrValue simpleVal;
        URI valType = val.getValueType();
        if (valType.compareTo((Object)ITypedValue.RELATIVEENTITYUDI_TYPE_URI) == 0) {
            if (!val.isSimple()) {
                throw new InvalidTypeException("Attribute values of type http://www.eclipse.org/higgins/ontologies/2008/6/higgins#RelativeEntityUDI must be simple types. " + val.getClass() + " is complex");
            }
            simpleVal = (ISimpleAttrValue)val;
            if (this._context == null) {
                throw new IdASException("Can't dereference this value because context is unknown at this time: " + simpleVal.getLexical());
            }
        } else {
            throw new UnhandledExtensionException("Cannot dereference values of type: " + valType);
        }
        ComplexValueEntityWrapper valOut = new ComplexValueEntityWrapper(this._context.getEntity(simpleVal.getCanonical()));
        return valOut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

