/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *    Tom Doman
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IAttribute;

public class AttributeNotification
{
	/**
	 * This action is set when the {@link IAttribute} returned by {@link #getAttr()} was added
	 */
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD";
	/**
	 * This action is set when the {@link IAttribute} returned by {@link #getAttr()} was removed
	 */
	public static final String UPDATE_REMOVE = "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE";
	/**
	 * This action is set when there is a {@link AttributeValueNotification} to be returned by {@link #getAttributeValueNotification()}
	 * This signifies that a value of this attribute was updated.
	 */
	public static final String UPDATE_VALUE_NOTIFY = "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY";
	/**
	 * This action is set when there is a {@link AttributeNotification} to be returned by {@link #getAttributeNotification()}
	 * This signifies that a meta-attribute element on this attribute was updated.
	 */
	public static final String UPDATE_ATTRIBUTE_NOTIFY = "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ATTRIBUTE_NOTIFY";

	private IAttribute _attr;
	private String _action;
	private AttributeValueNotification _attrValNotif;
	private AttributeNotification _metaAttrNotif;

	/**
	 * 
	 * @param attr
	 * @param action
	 * @param attrValNotif
	 */
	public AttributeNotification(
		IAttribute attr,
		String action,
		AttributeValueNotification attrValNotif,
		AttributeNotification metaAttrNotif)
	{
		_attr = attr;
		_action = action;
		_attrValNotif = attrValNotif;
		_metaAttrNotif = metaAttrNotif;
	}

	/**
	 * 
	 * @return the IAttribute being added or removed when the action is set to {@link #UPDATE_ADD} or {@link #UPDATE_REMOVE}
	 */
	public IAttribute getAttr()
	{
		return _attr;
	}

	/**
	 * 
	 * @return one of: {@link #UPDATE_ADD}, {@link #UPDATE_REMOVE}, {@link #UPDATE_ATTRIBUTE_NOTIFY}, {@link #UPDATE_VALUE_NOTIFY} 
	 */
	public String getAction()
	{
		return _action;
	}	

	/**
	 * 
	 * @return an AttributeValueNotification when the action is set to {@link #UPDATE_VALUE_NOTIFY}.
	 */
	public AttributeValueNotification getAttributeValueNotification()
	{
		return _attrValNotif;
	}

	/**
	 * 
	 * @return an AttributeNotification when the action is set to {@link #UPDATE_ATTRIBUTE_NOTIFY}.
	 */
	public AttributeNotification getAttributeNotification()
	{
		return _metaAttrNotif; 
	}
}
