/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.util.Date;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueGDay extends BasicValueDateTime implements ISimpleAttrValue {
	
	public BasicValueGDay(Date value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GDAY_TYPE_URI, value, container);
	}

	public BasicValueGDay(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GDAY_TYPE_URI, value, container);
	}

	/**
	 * TODO (Impl): I don't get why there are three dashes in front of the string representation
	 */
	protected String[] _getAllowedFormats() {
		// '-''-''-' dd (zzzzzz)?		
		return new String[]{"---dd'Z'",
							"---ddZ"};
	}
}
