/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueToken extends BasicValueNormalizedString implements ISimpleAttrValue {
	
	public BasicValueToken(String value, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.TOKEN_TYPE_URI, _normalize(value), container);
	}
	
	protected BasicValueToken() throws IdASException {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see BasicValueNormalizedString#_normalize(String)
	 */
	protected String _normalize(String value) {
		return super._normalize(value, WHITESPACE_RULE_COLLAPSE);
	}
}
