/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *    Tom Doman
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.IEntity;

public class EntityNotification
{
	/**
	 * This action is set when the {@link IEntity} returned by {@link #getEntity()} was added
	 */
	public static final String UPDATE_ADD = "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD";
	/**
	 * This action is set when the {@link IEntity} returned by {@link #getEntity()} was removed
	 */
	public static final String UPDATE_REMOVE = "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE";
	/**
	 * This action is set when there is a {@link AttributeNotification} to be returned by {@link #getAttributeNotification()}
	 * This signifies that an attribute on the entity was updated.
	 */
	public static final String UPDATE_ATTR_NOTIFY = "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY";

	private IEntity _entity;
	private String _action;
	private AttributeNotification _attrNotif;

	/**
	 * 
	 * @param entity
	 * @param action
	 * @param attrNotif
	 */
	public EntityNotification(
		IEntity entity,
		String action,
		AttributeNotification attrNotif)
	{
		_entity = entity;
		_action = action;
		_attrNotif = attrNotif;
	}

	/**
	 * 
	 * @return the IEntity being added or removed when the action is set to {@link #UPDATE_ADD} or {@link #UPDATE_REMOVE}
	 */
	public IEntity getEntity()
	{
		return _entity;
	}

	/**
	 * 
	 * @return one of: {@link #UPDATE_ADD}, {@link #UPDATE_REMOVE}, {@link #UPDATE_ATTRIBUTE_NOTIFY}, {@link #UPDATE_ATTR_NOTIFY} 
	 */
	public String getAction()
	{
		return _action;
	}	

	/**
	 * 
	 * @return an AttributeNotification when the action is set to {@link #UPDATE_ATTR_NOTIFY}.
	 */
	public AttributeNotification getAttributeNotification()
	{
		return _attrNotif;
	}
}
