/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilter implements IFilter {
	private IFilterAssertion _assertion = null;
	private String _operator = null;
	private Vector _filters = null; //<IFilter>
	
	public BasicFilter() {
		super();
	}

	public void setAssertion(IFilterAssertion assertion) throws IdASException {
		if ((_operator == null) && (_filters == null)) {
			_assertion = assertion;
		} else {
			throw new BadFilterException("Assertion cannot be added when operator or filter is present");
		}
	}

	/**
	 * @return assertion set by calling {@link #setAssertion(IFilterAssertion)}. May be null.
	 * @throws IdASException
	 */
	public IFilterAssertion getAssertion() throws IdASException {
		return _assertion;
	}

	public void setOperator(String operator) throws IdASException {
		if (_assertion == null) {
			_operator = operator;
		} else {
			throw new BadFilterException("Operator cannot be added when assertion is present");
		}
	}

	/**
	 * @return operator set by calling {@link #setOperator(String)}. May be null.
	 * @throws IdASException
	 */
	public String getOperator() throws IdASException {
		return _operator;
	}

	public void addFilter(IFilter filter) throws IdASException {
		if (_assertion == null) {
			if (_filters == null)
				_filters = new Vector();
			_filters.add(filter);
		} else {
			throw new BadFilterException("Filter cannot be added when assertion is present");
		}
	}

	public void addFilter(IFilterAssertion filterAssertion) throws IdASException {
		IFilter filter = new BasicFilter();
		filter.setAssertion(filterAssertion);
		addFilter(filter);
	}

	/**
	 * 
	 * @return an Iterator of IFilter objects set by {@link #addFilter(IFilter)}. May be null
	 * @throws IdASException
	 */
	public Iterator getFilters() throws IdASException {
		return _filters.iterator();
	}
}
