/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterEntityIDAssertion extends BasicFilterAssertion implements IFilterEntityIDAssertion {
	private String _assertion;
	
	public BasicFilterEntityIDAssertion() {
		super();
	}
	
	public BasicFilterEntityIDAssertion(URI id, String comparator) throws IdASException {
		super(id, false, comparator);
	}

	public BasicFilterEntityIDAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
	}

	public BasicFilterEntityIDAssertion(URI id, String comparator, String assertionValue) throws IdASException {
		super(id, comparator);
		setAssertionValue(assertionValue);
	}

	public BasicFilterEntityIDAssertion(URI id, boolean bIncludeSubtypes, String comparator, String assertionValue) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
		setAssertionValue(assertionValue);
	}

	public void setAssertionValue(String assertion) throws IdASException {
		_assertion = assertion;
	}

	public String getAssertionValue() throws IdASException {
		return _assertion;
	}

}
