/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;

import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicFilterEntityTypeAssertion extends BasicFilterAssertion implements IFilterEntityTypeAssertion {
	private URI _assertion;
	
	public BasicFilterEntityTypeAssertion() {
		super();
	}

	public BasicFilterEntityTypeAssertion(URI id, String comparator) throws IdASException {
		super(id, false, comparator);
	}

	public BasicFilterEntityTypeAssertion(URI id, boolean bIncludeSubtypes, String comparator) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
	}

	public BasicFilterEntityTypeAssertion(URI id, String comparator, URI assertionValue) throws IdASException {
		super(id, comparator);
		setAssertionValue(assertionValue);
	}

	public BasicFilterEntityTypeAssertion(URI id, boolean bIncludeSubtypes, String comparator, URI assertionValue) throws IdASException {
		super(id, bIncludeSubtypes, comparator);
		setAssertionValue(assertionValue);
	}

	public void setAssertionValue(URI assertion) throws IdASException {
		_assertion = assertion;
	}

	public URI getAssertionValue() throws IdASException {
		return _assertion;
	}

}
