/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.spi.BasicValueString;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public class BasicValueNormalizedString
extends BasicValueString
implements ISimpleAttrValue {
    public static final String WHITESPACE_RULE_PRESERVE = "preserve";
    public static final String WHITESPACE_RULE_REPLACE = "replace";
    public static final String WHITESPACE_RULE_COLLAPSE = "collapse";

    public BasicValueNormalizedString(String value, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.NORMALIZEDSTRING_TYPE_URI, this._normalize(value, WHITESPACE_RULE_REPLACE), container);
    }

    protected BasicValueNormalizedString() throws IdASException {
    }

    protected String _normalize(String value, String whitespaceRule) {
        if (whitespaceRule.equals(WHITESPACE_RULE_PRESERVE)) {
            return value;
        }
        int iLen = value.length();
        StringBuffer normVal = new StringBuffer(iLen);
        for (int iChar = 0; iChar < iLen; ++iChar) {
            char c = value.charAt(iChar);
            if (c != '\t' && c != '\r' && c != '\n') {
                normVal.append(c);
                continue;
            }
            if (c == '\r' && value.charAt(iChar + 1) == '\n') {
                ++iChar;
            }
            if (whitespaceRule.equals(WHITESPACE_RULE_COLLAPSE) && (normVal.length() == 0 || normVal.charAt(normVal.length() - 1) == ' ')) continue;
            normVal.append(' ');
        }
        if (whitespaceRule.equals(WHITESPACE_RULE_COLLAPSE) && normVal.charAt(normVal.length() - 1) == ' ') {
            normVal.deleteCharAt(normVal.length() - 1);
        }
        return normVal.toString();
    }
}

