/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;

public class ComplexValueEntityWrapper
implements IComplexAttrValue {
    private IEntity entity;

    public ComplexValueEntityWrapper(IEntity entity) {
        this.entity = entity;
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        return this.entity.equals((IHasAttributes)value);
    }

    public URI getDataType() throws IdASException {
        return this.entity.getEntityType();
    }

    public URI getValueType() throws IdASException {
        return this.entity.getModel().getType();
    }

    public boolean isSimple() throws IdASException {
        return false;
    }

    public void remove() throws IdASException {
        this.entity.remove();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return this.entity.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this.entity.addAttribute(copyFrom);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this.entity.equals(attributes);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this.entity.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this.entity.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this.entity.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this.entity.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this.entity.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this.entity.removeAttributeValue(attr);
    }

    public IEntityModel getModel() throws IdASException {
        return this.entity.getModel();
    }
}

