/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.math.BigDecimal;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueDecimal extends AbstractSimpleValue implements ISimpleAttrValue {

	public BasicValueDecimal(BigDecimal data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.DECIMAL_TYPE_URI, data, container);
	}

	public BasicValueDecimal(String data, IAttributeValueContainer container) throws IdASException {
		super();
		super.init(ITypedValue.DECIMAL_TYPE_URI, new BigDecimal(data), container);
	}

	public String getLexical() throws IdASException {
		return getCanonical();
	}

	/**
	 * Returns a string representation of teh backing {@link BigDecimal} without an exponent field.
	 */
	public String getCanonical() throws IdASException {
		return ((BigDecimal)getData()).toString();
	}
}
