/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.math.BigInteger;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValuePositiveInteger extends BasicValueInteger implements ISimpleAttrValue{
	
	public BasicValuePositiveInteger(BigInteger value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.POSITIVEINTEGER_TYPE_URI, value, container);
	}

	public BasicValuePositiveInteger(String value, IAttributeValueContainer container) throws IdASException {
		super.init(ITypedValue.POSITIVEINTEGER_TYPE_URI, new BigInteger(value), container);
	}

	protected void validate (BigInteger value) {
		if (value.signum() < 1) {
			throw new IllegalArgumentException();
		}
	}	
}
