/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IEntityModel;

/**
 * Basic implementation of {@link IComplexAttrValue}. Uses {@link IAttributeValueContainer}. 
 *
 */
public abstract class AbstractComplexValue extends BasicAttributeSet implements IComplexAttrValue {
	private IAttributeValueContainer container;
	private IEntityModel model;
	private URI type;

	/**
	 * Note that the container's updateNotification is not called while 
	 * the attributes in attrs are being added.
	 * @param attrs Contains {@link IAttribute}s.
	 */
	public AbstractComplexValue(URI type, Iterator attrs, IAttributeValueContainer container) throws IdASException {
		super(attrs, null, null);
		this.container = container;
		this.type = type;
		model = new BasicEntityModel(type); 
	}

	public boolean isSimple() throws IdASException {
		return false;
	}

	public void remove() throws IdASException {
		if (container != null) {
			AttributeValueNotification attrValueNotif = new AttributeValueNotification(this, AttributeValueNotification.UPDATE_REMOVE, null);
			container.updateNotification(attrValueNotif);
		}
	}

	/**
	 */
	protected URI getType() throws IdASException {
		return type;
	}

	public boolean equals(IAttributeValue value) throws IdASException {
		if (value.isSimple())
			return false;

		IComplexAttrValue val = (IComplexAttrValue)value;
		if (val.getModel().getType() != this.getModel().getType())
			return false;

		return ((BasicAttributeSet)this).equals((IHasAttributes)val);
	}

	public IEntityModel getModel() throws IdASException {
		return model;
	}

	public URI getValueType() throws IdASException {
		return getType();
	}

}
