/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.eclipse.higgins.idas.api.IdASException;

public class Base64 {
    public static final boolean ENCODE = true;
    public static final boolean DECODE = false;
    public static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    public byte[] encode3to4(byte[] threeBytes) {
        return this.encode3to4(threeBytes, 3);
    }

    public byte[] encode3to4(byte[] threeBytes, int numSigBytes) {
        byte[] dest = new byte[4];
        this.encode3to4(threeBytes, 0, numSigBytes, dest, 0);
        return dest;
    }

    public byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = this.ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = this.ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = this.ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = this.ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = this.ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public String encodeBytes(byte[] source) {
        return this.encodeBytes(source, 0, source.length);
    }

    public String encodeBytes(byte[] source, int off, int len) {
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + len43 / 76];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            this.encode3to4(source, d, 3, outBuff, e);
            if ((lineLength += 4) == 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            this.encode3to4(source, d, len - d, outBuff, e);
            e += 4;
        }
        return new String(outBuff, 0, e);
    }

    public String encodeString(String s) {
        return this.encodeBytes(s.getBytes());
    }

    public byte[] decode4to3(byte[] fourBytes) {
        byte[] outBuff1 = new byte[3];
        int count = this.decode4to3(fourBytes, 0, outBuff1, 0);
        byte[] outBuff2 = new byte[count];
        for (int i = 0; i < count; ++i) {
            outBuff2[i] = outBuff1[i];
        }
        return outBuff2;
    }

    public int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = this.DECODABET[source[srcOffset]] << 24 >>> 6 | this.DECODABET[source[srcOffset + 1]] << 24 >>> 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = this.DECODABET[source[srcOffset]] << 24 >>> 6 | this.DECODABET[source[srcOffset + 1]] << 24 >>> 12 | this.DECODABET[source[srcOffset + 2]] << 24 >>> 18;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = this.DECODABET[source[srcOffset]] << 24 >>> 6 | this.DECODABET[source[srcOffset + 1]] << 24 >>> 12 | this.DECODABET[source[srcOffset + 2]] << 24 >>> 18 | this.DECODABET[source[srcOffset + 3]] << 24 >>> 24;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public byte[] decode(String s) throws IdASException {
        byte[] bytes = s.getBytes();
        return this.decode(bytes, 0, bytes.length);
    }

    public String decodeToString(String s) throws IdASException {
        return new String(this.decode(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decodeToObject(String encodedObject) throws IdASException {
        byte[] objBytes = this.decode(encodedObject);
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(objBytes);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            Object var6_10 = null;
            return var6_10;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Object var6_11 = null;
            return var6_11;
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception e) {}
            try {
                ois.close();
            }
            catch (Exception e) {}
        }
    }

    public byte[] decode(byte[] source, int off, int len) throws IdASException {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = 0; i < len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = this.DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += this.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            throw new IdASException("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }
}

