/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.spi.AbstractSimpleValue;
import org.eclipse.higgins.idas.spi.IAttributeValueContainer;

public class BasicValueDateTime
extends AbstractSimpleValue
implements ISimpleAttrValue {
    private int _formatUsed;

    public BasicValueDateTime(Date data, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.DATETIME_TYPE_URI, data, container);
    }

    public BasicValueDateTime(String data, IAttributeValueContainer container) throws IdASException {
        super.init(ITypedValue.DATETIME_TYPE_URI, this._parseString(data), container);
    }

    protected BasicValueDateTime(URI type, Date data, IAttributeValueContainer container) throws IdASException {
        super.init(type, data, container);
    }

    protected BasicValueDateTime(URI type, String data, IAttributeValueContainer container) throws IdASException {
        super.init(type, this._parseString(data), container);
    }

    public String getLexical() throws IdASException {
        SimpleDateFormat sdf = new SimpleDateFormat(this._getAllowedFormats()[this._formatUsed]);
        return sdf.format((Date)this.getData());
    }

    public String getCanonical() throws IdASException {
        SimpleDateFormat sdf = new SimpleDateFormat(this._getAllowedFormats()[0]);
        return sdf.format((Date)this.getData());
    }

    private Date _parseString(String value) throws IdASException {
        SimpleDateFormat sdf = new SimpleDateFormat();
        String[] formats = this._getAllowedFormats();
        Date date = null;
        this._formatUsed = 0;
        while (this._formatUsed < formats.length) {
            try {
                sdf.applyPattern(formats[this._formatUsed]);
                date = sdf.parse(value);
                break;
            }
            catch (ParseException e) {
                ++this._formatUsed;
            }
        }
        if (date == null) {
            throw new IdASException("Unable to parse date value: " + value);
        }
        return date;
    }

    protected String[] _getAllowedFormats() {
        return new String[]{"yyyy-MM-dd'T'HH:mm:ss.S'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ssZ"};
    }
}

