/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicComplexValue  extends AbstractComplexValue implements IComplexAttrValue {
	
	public static final String XML_TYPE_STR = "any";
	public static final String OWL_TYPE_STR = XML_TYPE_STR + ISimpleAttrValue.OWL_TYPE_SUFFIX;
	public static final String ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + OWL_TYPE_STR;
	public static final String ATTR_VALUE_TYPE_URI_STR = ISimpleAttrValue.BASE_XML_SCHEMA_URI + XML_TYPE_STR;


	public BasicComplexValue(URI type, Iterator attrs, IAttributeValueContainer container) throws IdASException {
		super(type, attrs, container);
	}

	/**
	 * Returns a URI for {@value #ATTR_VALUE_TYPE_URI_STR} or internal type if set in the constructor
	 */
	protected URI getType() throws IdASException {
		if (super.getType() != null)
			return super.getType();
		return URI.create(ATTR_VALUE_TYPE_URI_STR);
	}

	public URI getDataType() throws IdASException {
		return getModel().getType();
	}

}
