/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.util.Date;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueGMonthDay extends BasicValueDateTime implements ISimpleAttrValue {
	
	public BasicValueGMonthDay(Date value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GMONTHDAY_TYPE_URI, value, container);
	}

	public BasicValueGMonthDay(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GMONTHDAY_TYPE_URI, value, container);
	}

	/**
	 * TODO (Impl): I don't get why there are two dashes in front of the string representation
	 */
	protected String[] _getAllowedFormats() {
		// '-''-' mm '-' dd (zzzzzz)?		
		return new String[]{"--MM-dd'Z'",
							"--MM-ddZ"};
	}
}
