/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interface
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * Basic implementation of {@link IAuthNAttributesMaterials} for use in {@link IContext#open(Object)}.  
 */
public class BasicAuthNAttributesMaterials extends BasicAttributeSet implements
		IAuthNAttributesMaterials {

	/**
	 * @throws IdASException 
	 * 
	 */
	public BasicAuthNAttributesMaterials(Iterator attrs, IContext context) throws IdASException {
		super(attrs, null, context);
	}

	public IAttribute getManagedAttr() {
		return null;
	}

	public URI getManagedAttrID() {
		return null;
	}
}
