/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.spi;

import java.util.Date;

import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public class BasicValueGYearMonth extends BasicValueDateTime implements ISimpleAttrValue {
	
	public BasicValueGYearMonth(Date value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GYEARMONTH_TYPE_URI, value, container);
	}

	public BasicValueGYearMonth(String value, IAttributeValueContainer container) throws IdASException {
		super(ITypedValue.GYEARMONTH_TYPE_URI, value, container);
	}

	protected String[] _getAllowedFormats() {
		//'-'? yyyy '-' mm (zzzzzz)?		
		return new String[]{"yyyy-MM'Z'",
							"yyyy-MMZ"};
	}

}
