/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IAttributeUDIMetadata;
import org.eclipse.higgins.idas.udi.IAuthnNMaterialsProxy;
import org.eclipse.higgins.idas.udi.IContextUDI;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDI;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.IUDIFactory;

public class UDIResolver
implements IConfigurableComponent,
IConfigurableComponentFactory {
    private static UDIResolver impl = null;
    private List udiFactoryList = new ArrayList();

    public static synchronized UDIResolver getInstance() {
        if (impl == null) {
            impl = new UDIResolver();
        }
        return impl;
    }

    public IConfigurableComponent getNewInstance() {
        return new IdASRegistry();
    }

    public IConfigurableComponent getSingletonInstance() {
        return UDIResolver.getInstance();
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
        List udiFactoryInstances = (List)mapComponentSettings.get("UDIFactoryInstancesList");
        this.udiFactoryList.clear();
        Iterator i = udiFactoryInstances.iterator();
        while (i.hasNext()) {
            String udiFactoryString = (String)i.next();
            IUDIFactory udiFactory = (IUDIFactory)mapComponentSettings.get(udiFactoryString);
            if (udiFactory == null) {
                udiFactory = (IUDIFactory)mapGlobalSettings.get(udiFactoryString);
            }
            if (udiFactory == null) {
                throw new NullPointerException("UDI Factory " + udiFactoryString + " not found in configuration.");
            }
            this.udiFactoryList.add(udiFactory);
        }
    }

    public List getUdiFactoryList() {
        return this.udiFactoryList;
    }

    public IContextUDI parseContextUDI(String contextUDIStr) throws IdASException {
        IContextUDI contextUDI = null;
        Iterator i = this.udiFactoryList.iterator();
        while (i.hasNext()) {
            IUDIFactory udiFactory = (IUDIFactory)i.next();
            contextUDI = udiFactory.parseContextUDI(contextUDIStr);
            if (contextUDI != null) break;
        }
        return contextUDI;
    }

    public IEntityUDI parseEntityUDI(String entityUDIStr) throws IdASException {
        IEntityUDI entityUDI = null;
        Iterator i = this.udiFactoryList.iterator();
        while (i.hasNext()) {
            IUDIFactory udiFactory = (IUDIFactory)i.next();
            entityUDI = udiFactory.parseEntityUDI(entityUDIStr);
            if (entityUDI != null) break;
        }
        return entityUDI;
    }

    public IAttributeUDI parseAttributeUDI(String attributeUDIStr) throws IdASException {
        IAttributeUDI attributeUDI = null;
        Iterator i = this.udiFactoryList.iterator();
        while (i.hasNext()) {
            IUDIFactory udiFactory = (IUDIFactory)i.next();
            attributeUDI = udiFactory.parseAttributeUDI(attributeUDIStr);
            if (attributeUDI != null) break;
        }
        return attributeUDI;
    }

    public IContext resolve(IContextUDI contextUDI) throws IdASException {
        IContextUDIMetadata contextUDIMetadata = contextUDI.getContextUDIMetadata();
        return this.resolve(contextUDIMetadata);
    }

    public IEntity resolve(IEntityUDI entityUDI, IAuthnNMaterialsProxy authnMaterialsProxy) throws IdASException {
        IEntityUDIMetadata entityUDIMetadata = entityUDI.getEntityUDIMetadata();
        return this.resolve(entityUDIMetadata, authnMaterialsProxy);
    }

    public IAttribute resolve(IAttributeUDI attributeUDI, IAuthnNMaterialsProxy authnMaterialsProxy) throws IdASException {
        IAttributeUDIMetadata attributeUDIMetadata = attributeUDI.getAttributeUDIMetadata();
        return this.resolve(attributeUDIMetadata, authnMaterialsProxy);
    }

    private IContext resolve(IContextUDIMetadata contextUDIMetadata) throws IdASException {
        IdASRegistry idasRegistry = IdASRegistry.getInstance();
        Object[] types = contextUDIMetadata.getTypes();
        Map configuration = contextUDIMetadata.getConfiguration();
        IContextFactory contextFactory = idasRegistry.getContextFactory((String[])types);
        if (contextFactory == null) {
            throw new IdASException("No Context Provider found for types " + UDIResolver.join(types, " ") + ".");
        }
        IContext context = contextFactory.createContext((IContextId)new ContextUDIWrapper((String[])types, configuration));
        if (context == null) {
            throw new IdASException("Cannot create Context.");
        }
        return context;
    }

    private IEntity resolve(IEntityUDIMetadata entityUDIMetadata, IAuthnNMaterialsProxy authnMaterialsProxy) throws IdASException {
        IContextUDIMetadata contextUDIMetadata = entityUDIMetadata.getContextUDIMetadata();
        String entityID = entityUDIMetadata.getEntityID();
        IContext context = this.resolve(contextUDIMetadata);
        context.open(authnMaterialsProxy.buildAuthNAttributesMaterials(context));
        IEntity entity = context.getEntity(entityID);
        if (entity == null) {
            throw new IdASException("Cannot get Entity.");
        }
        return entity;
    }

    private IAttribute resolve(IAttributeUDIMetadata attributeUDIMetadata, IAuthnNMaterialsProxy authnMaterialsProxy) throws IdASException {
        IEntityUDIMetadata entityUDIMetadata = attributeUDIMetadata.getEntityUDIMetadata();
        URI attributeID = attributeUDIMetadata.getAttributeID();
        IEntity entity = this.resolve(entityUDIMetadata, authnMaterialsProxy);
        if (entity == null) {
            throw new IdASException("Cannot get Entity.");
        }
        IAttribute attribute = entity.getAttribute(attributeID);
        if (entity == null) {
            throw new IdASException("Cannot get Attribute.");
        }
        return attribute;
    }

    public static String join(Object[] array, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Object> i = Arrays.asList(array).iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static class ContextUDIWrapper
    implements IContextId {
        private String[] types;
        private Map configuration;

        private ContextUDIWrapper(String[] types, Map configuration) {
            this.types = types;
            this.configuration = configuration;
        }

        public Map getConfiguration() throws IdASException {
            return this.configuration;
        }

        public String[] getTypes() throws IdASException {
            return this.types;
        }

        public URI[] getUris() throws IdASException {
            return new URI[0];
        }
    }
}

