/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.hashuri;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;
import org.eclipse.higgins.idas.udi.impl.hashuri.HashURIEntityUDIMetadata;

public class HashURIEntityUDI
extends AbstractEntityUDI {
    private static final long serialVersionUID = 1487832350932621276L;
    private String entityUDI;
    private IEntityUDIMetadata entityUDIMetadata;

    public HashURIEntityUDI(String entityUDI) throws IdASException {
        super(entityUDI);
        this.entityUDI = entityUDI;
        this.entityUDIMetadata = null;
    }

    public IEntityUDIMetadata getEntityUDIMetadata() {
        if (this.entityUDIMetadata == null) {
            this.entityUDIMetadata = new HashURIEntityUDIMetadata(this.entityUDI);
        }
        return this.entityUDIMetadata;
    }

    static boolean canParse(String entityUDI) {
        URI uri;
        try {
            uri = new URI(entityUDI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        if (uri.getScheme() == null) {
            return false;
        }
        return uri.getFragment() != null;
    }
}

