/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.xri;

import java.util.ArrayList;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;

public class XRIContextUDIMetadata
extends XRDSContextUDIMetadata {
    private String contextUDI;
    private Resolver resolver;

    XRIContextUDIMetadata(String contextUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) {
        this.contextUDI = contextUDI;
        this.resolver = resolver;
    }

    protected void resolve() throws IdASException {
        ArrayList selectedServices;
        try {
            XRI xri = new XRI(this.contextUDI);
            XRD xrd = this.resolver.resolveSEPToXRD(xri, new TrustType("none"), "$context", null, true, new ResolverState());
            selectedServices = xrd.getSelectedServices().getList();
            if (selectedServices == null || selectedServices.size() < 1) {
                throw new IdASException("No service endpoints selected.");
            }
        }
        catch (IdASException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IdASException("Cannot resolve XRI " + this.contextUDI + ": " + ex.getMessage(), (Throwable)ex);
        }
        this.service = (Service)selectedServices.get(0);
    }
}

