/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.conf;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractContextUDI;

public class ConfContextUDI extends AbstractContextUDI {

	private static final long serialVersionUID = -4866767688420482579L;

	private IContextUDIMetadata contextUDIMetadata;

	public ConfContextUDI(String contextUDI) throws IdASException {

		super(contextUDI);

		this.contextUDIMetadata = null;
	}

	public IContextUDIMetadata getContextUDIMetadata() {

		if (this.contextUDIMetadata == null) this.contextUDIMetadata = new ConfContextUDIMetadata(this.contextUDI);

		return(this.contextUDIMetadata);
	}

	static boolean canParse(String contextUDI) {

		try {

			if (ContextIdFactory.fromConfiguration(contextUDI) == null) return(false);
		} catch (Exception ex) {

			return(false);
		}

		return(true);
	}
}