/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.uri;

import java.net.URL;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.eclipse.higgins.idas.udi.util.XRDSDownloader;
import org.openxri.xml.XRD;

public class URIContextUDIMetadata extends XRDSContextUDIMetadata {

	private String contextUDI;

	URIContextUDIMetadata(String contextUDI) {

		this.contextUDI = contextUDI;
	}

	protected void resolve() throws IdASException {

		XRD xrd;

		try {

			URL url = new URL(this.contextUDI);

			xrd = XRDSDownloader.discoverXRDS(url).getFinalXRD();
		} catch (Exception ex) {

			throw new IdASException("Cannot download XRDS from URL " + this.contextUDI + ": " + ex.getMessage(), ex);
		}

		this.service = xrd.getServiceAt(0);
	}
}
