/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.uri;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractEntityUDI;

public class URIEntityUDI extends AbstractEntityUDI {

	private static final long serialVersionUID = 7896597422790522715L;

	private String entityUDI;

	private IEntityUDIMetadata entityUDIMetadata;

	public URIEntityUDI(String entityUDI) throws IdASException {

		super(entityUDI);

		this.entityUDI = entityUDI;

		this.entityUDIMetadata = null;
	}

	public IEntityUDIMetadata getEntityUDIMetadata() {

		if (this.entityUDIMetadata == null) this.entityUDIMetadata = new URIEntityUDIMetadata(this.entityUDI);

		return(this.entityUDIMetadata);
	}

	static boolean canParse(String entityUDI) {

		URI uri;

		try {

			uri = new URI(entityUDI);
		} catch (URISyntaxException ex) {

			return(false);
		}

		if (uri.getScheme() == null) return(false);
		if (uri.getFragment() != null) return(false);

		return(true);
	}
}