/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.uri;

import java.util.Map;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IContextUDI;
import org.eclipse.higgins.idas.udi.IEntityUDI;
import org.eclipse.higgins.idas.udi.IUDIFactory;

public class URIUDIFactory implements IUDIFactory {
	
	static final String[] SEP_TYPES = new String[] {
		"http://specs.openid.net/auth/2.0/server",
		"http://openid.net/signon/1.1",
		"http://openid.net/signon/1.0",
		"$context",
		null
	};

	static final String[] TYPES_RDF = new String[] { 
		"$context$mime*application*rdf.xml",	
		"$context"
	};

	public URIUDIFactory() {
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {

	}

	public IContextUDI parseContextUDI(String contextUDI) throws IdASException {

		if (! URIContextUDI.canParse(contextUDI)) return(null);

		return(new URIContextUDI(contextUDI));
	}

	public IEntityUDI parseEntityUDI(String entityUDI) throws IdASException {

		if (! URIEntityUDI.canParse(entityUDI)) return(null);

		return(new URIEntityUDI(entityUDI));
	}

	public IAttributeUDI parseAttributeUDI(String attributeUDI) throws IdASException {

		return(null);
	}
}
