/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.udi.impl.xri;

import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.AbstractAttributeUDI;
import org.openxri.resolve.Resolver;

public class XRIAttributeUDI extends AbstractAttributeUDI {

	private static final long serialVersionUID = 7199446865183698114L;

	private Resolver resolver;
	private boolean https;
	private boolean saml;
	private boolean cid;
	private boolean refs;

	private IAttributeUDIMetadata attributeUDIMetadata;

	public XRIAttributeUDI(String attributeUDI, Resolver resolver, boolean https, boolean saml, boolean cid, boolean refs) throws IdASException {

		super(attributeUDI);

		this.resolver = resolver;
		this.https = https;
		this.saml = saml;
		this.cid = cid;
		this.refs = refs;

		this.attributeUDIMetadata = null;
	}

	public IAttributeUDIMetadata getAttributeUDIMetadata() {

		if (this.attributeUDIMetadata == null) this.attributeUDIMetadata = new XRIAttributeUDIMetadata(this.attributeUDI, this.resolver, this.https, this.saml, this.cid, this.refs);

		return(this.attributeUDIMetadata);
	}

	static boolean canParse(String attributeUDI) {

		if (! attributeUDI.startsWith("xri://") &&
				! attributeUDI.startsWith("=") &&
				! attributeUDI.startsWith("@") &&
				! attributeUDI.startsWith("+") &&
				! attributeUDI.startsWith("$")) return(false);

		return(true);
	}
}